package org.msh.tb.bd.dashboard.detailedrep;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.international.Messages;
import org.msh.tb.bd.dashboard.query.Indicator03Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.indicators.core.IndicatorTable;
import org.msh.utils.reportgen.highchart.ChartCreator;
import org.msh.utils.reportgen.highchart.ChartOptions;
import org.msh.utils.reportgen.highchart.Series;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * Created by Mauricio on 11/05/2017.
 */
@Name("detailedIndicator03")
public class DetailedIndicator03 extends DetailedIndicator<Indicator03Query> {

    @Override
    protected void createIndicators() {
        AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();

        // set params to indicator query
        getQuery().setIniDate(getIndicatorFilters().getIniDate());
        getQuery().setEndDate(getIndicatorFilters().getEndDate());
        getQuery().setSelectedAdminUnit(auSelected);

        List<Object[]> result = getQuery().getDetailedResult();

        // check root name
        String rootLabel = auSelected == null ? "Bangladesh" : auSelected.getCountryStructure().getName() + ": " + auSelected.getName().getName1();

        // populate indicator table
        for(Object[] r : result){
            String adminUnit = (String) r[0];
            Long population = (Long) r[1];
            Long caseQtt = (Long) r[2];
            Float rate = (Float) r[3];

            if (adminUnit.equals("root")) {
                adminUnit = rootLabel;
            }

            addValue(getMessage("dashboard.indicator03.cases"), adminUnit, caseQtt != null ? caseQtt.floatValue() : 0);
            addValue(getIndicatorFilters().getIniYear() + " " + getMessage("population"), adminUnit, population != null ? population.floatValue() : 0);
            addValue(getMessage("dashboard.indicator03.rate"), adminUnit, rate);
        }

        // set highlight in root row
        getTable().getRows().get(getTable().getRows().size()-1).setHighlight(true);
    }


    @Override
    protected Indicator03Query getQueryNewInstance() {
        return new Indicator03Query();
    }

    @Override
    protected void createChartData() {
        if (getTable() == null)
            return;

        chartCreator = new ChartCreator();
        ChartOptions opt = chartCreator.getOptions();
        opt.getChart().setRenderTo("chartdiv");
        opt.getChart().setType(getIndicatorFilters().getHighChartType());
        Series series = opt.addSeries();

        String rateColumnLabel = Messages.instance().get("dashboard.indicator03.rate");
        series.setName(rateColumnLabel);

        for (IndicatorTable.TableRow row: getTable().getRows()) {
            for (IndicatorTable.TableCell cell: row.getCells()) {
                if (cell.getColumn().getTitle() != null && cell.getColumn().getTitle().equals(rateColumnLabel) && cell.getValue() > 0) {
                    BigDecimal bd = new BigDecimal(cell.getValue().doubleValue()).setScale(3, RoundingMode.HALF_EVEN);
                    series.addNewValue(bd.doubleValue());
                    opt.getxAxis().getCategories().add(cell.getRow().getTitle());
                }
            }
        }

        opt.getTitle().setText(Messages.instance().get("dashboard.indicator03"));
    }
}
